/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.CIMUtils;
import com.ibm.hsc.common.util.PIHscUtil;
import com.ibm.hsc.common.util.QueryParts;
import com.ibm.hsc.common.util.Trace;
import com.ibm.websm.etc.EExec;
import com.ibm.websm.etc.EExecResult;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt8;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ListHSC {
    public static final int RETURN_OK = 0;
    public static final int RETURN_EXTRANEOUS = 16;
    public static final int RETURN_INSUFFICIENT = 32;
    public static final int RETURN_DUPLICATE = 48;
    public static final int RETURN_UNKNOWN = 64;
    public static final int RETURN_INVALID = 80;
    public static final int RETURN_CONFLICT = 96;
    public static final int RETURN_NO_MTMS = 112;
    public static final int RETURN_CIM_EXCEPTION = 144;
    public static final int RETURN_CIM_UNKNOWN_ERROR = 160;
    public static final int RETURN_INTERNAL_ERROR = 176;
    public static final int RETURN_NO_COREQ_PARM = 208;
    private static final char INVENTORY_SCOUT_PARM = 'i';
    private static final char OBJECT_TYPE_ALL_PARM = 'a';
    private static final char OBJECT_TYPE_PARM = 't';
    private static final char CEC_PARM = 'c';
    private static final char IO_DRAWER_PARM = 'd';
    private static final char RESOURCE_ID_PARM = 'r';
    private static final char CEC_MODE_PARM = 'm';
    private static final char VPD_INFO_PARM = 'v';
    private static final char PARTITION_INFO_PARM = 'p';
    private static final char BPA_INFO_PARM = 'b';
    private static final char QUERY_PART_INFO_PARM = 'w';
    private static final char FILENAME_PARM = 'f';
    private static final char XML_OUTPUT_PARM = 'x';
    private static final char MACHINE_TYPE_MODEL_AND_SERIAL_SEPARATOR_CHAR = '_';
    private static final char CIM_MACHINE_TYPE_MODEL_AND_SERIAL_SEPARATOR_CHAR = '*';
    private static final char TYPE_AND_VALUE_SEPARATOR_CHAR = ':';
    private static final char TYPE_AND_VALUE_DELIMETER_CHAR = ';';
    private static final char VALUE_PAIRS_DELIMETER_CHAR = ';';
    public static final String CEC_TYPE_STRING = "0";
    public static final String IO_DRAWER_TYPE_STRING = "1";
    public static final String BPA_TYPE_STRING = "3";
    private static final String CEC_PARTITIONED_CHAR = "0";
    private static final String CEC_NOT_PARTITIONED_CHAR = "1";
    private static final String TRACE_MASKD = "JLSTHSCD";
    private static final String TRACE_MASKF = "JLSTHSCF";
    private static final String TRACE_MASKT = "JLSTHSCT";
    private static String _unallocResXml = null;
    private static boolean _xmlOutput = false;
    private static String _cecMTMS = "";

    private ListHSC() {
    }

    public void setXmlOutput(boolean bl) {
        _xmlOutput = bl;
    }

    public static void main(String[] stringArray) {
        int n;
        Object object;
        int n2 = 0;
        String string = null;
        Hashtable<Character, Parameter> hashtable = null;
        Parameter parameter = null;
        Parameter parameter2 = null;
        String string2 = null;
        Character c = null;
        Parameter parameter3 = null;
        Character c2 = null;
        String string3 = null;
        Object var11_11 = null;
        boolean bl = false;
        Object var13_13 = null;
        boolean bl2 = false;
        String string4 = null;
        EExecResult eExecResult = null;
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        if (Trace.LEVEL >= 3) {
            object = new StringBuffer();
            for (n = 0; n < stringArray.length; ++n) {
                ((StringBuffer)object).append(' ');
                ((StringBuffer)object).append(stringArray[n]);
            }
            Trace.trace(TRACE_MASKD, "lshsc called with the following parameters :" + ((StringBuffer)object).toString());
        }
        if (stringArray.length == 0) {
            ListHSC.displayHelp();
            ListHSC.doExit(0);
        }
        hashtable = new Hashtable<Character, Parameter>();
        hashtable.put(new Character('i'), new Parameter(false, 0));
        hashtable.put(new Character('a'), new Parameter(false, 0));
        hashtable.put(new Character('t'), new Parameter(true, 0));
        hashtable.put(new Character('c'), new Parameter(true, 0));
        hashtable.put(new Character('d'), new Parameter(false, 0));
        hashtable.put(new Character('r'), new Parameter(false, 0));
        hashtable.put(new Character('m'), new Parameter(false, 0));
        hashtable.put(new Character('v'), new Parameter(false, 0));
        hashtable.put(new Character('p'), new Parameter(false, 0));
        hashtable.put(new Character('b'), new Parameter(true, 0));
        hashtable.put(new Character('w'), new Parameter(false, 0));
        hashtable.put(new Character('f'), new Parameter(true, 0));
        hashtable.put(new Character('x'), new Parameter(false, 0));
        for (n2 = 1; n2 <= stringArray.length; ++n2) {
            string2 = stringArray[n2 - 1].trim();
            if (string2.charAt(0) == '-') {
                if (string2.length() > 1) {
                    c = new Character(string2.charAt(1));
                    parameter = (Parameter)hashtable.get(c);
                    if (parameter != null) {
                        if (parameter.getCount() == 0) {
                            if (string2.length() > 2) {
                                if (parameter.getExtraInfoRequired()) {
                                    parameter.setExtraInfo(string2.substring(2));
                                    parameter.setCount(n2);
                                    continue;
                                }
                                ListHSC.doExit(16 + n2);
                                continue;
                            }
                            if (parameter.getExtraInfoRequired()) {
                                if (n2 + 1 > stringArray.length) {
                                    ListHSC.doExit(32 + n2);
                                    continue;
                                }
                                parameter.setCount(n2);
                                parameter.setExtraInfo(stringArray[++n2 - 1].trim());
                                object = new Character('c');
                                if (!c.equals(object)) continue;
                                _cecMTMS = parameter.getExtraInfo();
                                continue;
                            }
                            parameter.setCount(n2);
                            continue;
                        }
                        ListHSC.doExit(48 + n2);
                        continue;
                    }
                    ListHSC.doExit(64 + n2);
                    continue;
                }
                ListHSC.doExit(32 + n2);
                continue;
            }
            ListHSC.doExit(80 + n2);
        }
        parameter3 = null;
        object = hashtable.keys();
        block39: while (object.hasMoreElements()) {
            c2 = (Character)object.nextElement();
            parameter = (Parameter)hashtable.get(c2);
            if (parameter.getCount() <= 0) continue;
            switch (c2.charValue()) {
                case 'a': 
                case 'b': 
                case 'd': 
                case 'm': 
                case 'p': 
                case 'r': 
                case 't': 
                case 'v': 
                case 'w': {
                    if (parameter3 == null) {
                        parameter3 = parameter;
                        continue block39;
                    }
                    ListHSC.doExit(96 + Math.max(parameter.getCount(), parameter3.getCount()));
                    continue block39;
                }
            }
        }
        parameter = (Parameter)hashtable.get(new Character('c'));
        if (parameter != null && parameter.getCount() > 0) {
            stringArray2 = ListHSC.parseMTMS(parameter);
        }
        if ((parameter = (Parameter)hashtable.get(new Character('b'))) != null && parameter.getCount() > 0) {
            stringArray3 = ListHSC.parseMTMS(parameter);
        }
        if ((parameter = (Parameter)hashtable.get(new Character('f'))) != null && parameter.getCount() > 0) {
            string = parameter.getExtraInfo();
            if (string == null || string.length() == 0) {
                ListHSC.doExit(32 + parameter.getCount());
            }
            if ((parameter2 = (Parameter)hashtable.get(new Character('w'))) == null || parameter2.getCount() == 0) {
                ListHSC.doExit(208 + parameter.getCount());
            }
            if ((parameter2 = (Parameter)hashtable.get(new Character('c'))) == null || parameter2.getCount() == 0) {
                ListHSC.doExit(208 + parameter.getCount());
            }
        }
        _xmlOutput = ListHSC.xmlFlagGiven(hashtable);
        PIHscUtil.initHscUtil(3);
        object = hashtable.keys();
        block40: while (object.hasMoreElements()) {
            c2 = (Character)object.nextElement();
            parameter = (Parameter)hashtable.get(c2);
            if (parameter.getCount() <= 0) continue;
            switch (c2.charValue()) {
                case 'x': {
                    _xmlOutput = true;
                    continue block40;
                }
                case 'i': {
                    if (parameter3 != null) continue block40;
                    parameter2 = (Parameter)hashtable.get(new Character('c'));
                    if (parameter2 != null) {
                        if (parameter2.getCount() != 0) continue block40;
                        System.out.print("0");
                        if (Trace.LEVEL >= 3) {
                            Trace.trace(TRACE_MASKD, "writing to standard out : 0");
                        }
                        ListHSC.doExit(0);
                        continue block40;
                    }
                    ListHSC.doExit(176);
                    continue block40;
                }
                case 'a': {
                    try {
                        ListHSC.listAllTypes();
                    }
                    catch (CIMException cIMException) {
                        ListHSC.traceException((Exception)((Object)cIMException));
                        ListHSC.doExit(144);
                    }
                    ListHSC.doExit(0);
                    continue block40;
                }
                case 't': {
                    string3 = parameter.getExtraInfo();
                    if (string3 != null && string3.length() > 0) {
                        for (n = 0; n < string3.length(); ++n) {
                            if (Character.isDigit(string3.charAt(n))) continue;
                            ListHSC.doExit(80 + parameter.getCount());
                        }
                    } else {
                        ListHSC.doExit(32 + parameter.getCount());
                    }
                    try {
                        ListHSC.listType(string3, true);
                    }
                    catch (CIMException cIMException) {
                        ListHSC.traceException((Exception)((Object)cIMException));
                        ListHSC.doExit(144);
                    }
                    ListHSC.doExit(0);
                    continue block40;
                }
                case 'c': {
                    if (parameter3 != null) continue block40;
                    try {
                        ListHSC.listComponents(stringArray2[0], stringArray2[1]);
                    }
                    catch (CIMException cIMException) {
                        ListHSC.traceException((Exception)((Object)cIMException));
                        ListHSC.doExit(144);
                    }
                    ListHSC.doExit(0);
                    continue block40;
                }
                case 'd': {
                    if (stringArray2 == null) {
                        ListHSC.doExit(112 + parameter.getCount());
                    }
                    try {
                        ListHSC.listAdapters(stringArray2[0], stringArray2[1]);
                    }
                    catch (PIHscClientException pIHscClientException) {
                        pIHscClientException.printStackTrace();
                        ListHSC.traceException(pIHscClientException);
                        ListHSC.doExit(144);
                    }
                    ListHSC.doExit(0);
                    continue block40;
                }
                case 'r': {
                    if (stringArray2 == null) {
                        ListHSC.doExit(112 + parameter.getCount());
                    }
                    try {
                        ListHSC.listHSCs(stringArray2[0], stringArray2[1]);
                    }
                    catch (CIMException cIMException) {
                        ListHSC.traceException((Exception)((Object)cIMException));
                        ListHSC.doExit(144);
                    }
                    catch (PIHscClientException pIHscClientException) {
                        ListHSC.traceException(pIHscClientException);
                        ListHSC.doExit(144);
                    }
                    ListHSC.doExit(0);
                    continue block40;
                }
                case 'm': {
                    if (stringArray2 == null) {
                        ListHSC.doExit(112 + parameter.getCount());
                    }
                    try {
                        if (ListHSC.listMode(stringArray2[0], stringArray2[1])) {
                            ListHSC.doExit(0);
                            continue block40;
                        }
                        ListHSC.doExit(160);
                    }
                    catch (CIMException cIMException) {
                        ListHSC.traceException((Exception)((Object)cIMException));
                        ListHSC.doExit(144);
                    }
                    continue block40;
                }
                case 'v': {
                    try {
                        bl2 = ListHSC.listVPD();
                        if (!bl2) {
                            ListHSC.doExit(160);
                        }
                    }
                    catch (CIMException cIMException) {
                        ListHSC.traceException((Exception)((Object)cIMException));
                        ListHSC.doExit(144);
                    }
                    ListHSC.doExit(0);
                    continue block40;
                }
                case 'w': {
                    parameter2 = (Parameter)hashtable.get(new Character('c'));
                    if (parameter2 == null || parameter2.getCount() == 0) {
                        ListHSC.doExit(208 + parameter.getCount());
                    }
                    try {
                        QueryParts.partitionInfo(stringArray2[0] + '*' + stringArray2[1], string);
                    }
                    catch (PIHscClientException pIHscClientException) {
                        ListHSC.traceException(pIHscClientException);
                        ListHSC.doExit(144);
                    }
                    ListHSC.doExit(0);
                    continue block40;
                }
                case 'f': {
                    continue block40;
                }
                case 'p': {
                    if (stringArray2 == null) {
                        ListHSC.doExit(112 + parameter.getCount());
                    }
                    if ((string4 = (eExecResult = EExec.Exec((String)("/opt/hsc/bin/lspartition -i -c" + stringArray2[0] + '_' + stringArray2[1]))).getStdout()) != null && string4.length() > 0) {
                        if (Trace.LEVEL >= 3) {
                            Trace.trace(TRACE_MASKD, "writing to standard out : " + string4);
                        }
                        System.out.print(string4);
                    }
                    ListHSC.doExit(eExecResult.rc);
                    continue block40;
                }
                case 'b': {
                    if (stringArray3 == null) {
                        ListHSC.doExit(112 + parameter.getCount());
                    }
                    try {
                        ListHSC.listBPAComponents(stringArray3[0], stringArray3[1]);
                    }
                    catch (CIMException cIMException) {
                        ListHSC.traceException((Exception)((Object)cIMException));
                        ListHSC.doExit(144);
                    }
                    ListHSC.doExit(0);
                    continue block40;
                }
            }
            ListHSC.doExit(176);
        }
        ListHSC.doExit(176);
    }

    private static boolean xmlFlagGiven(Hashtable hashtable) {
        boolean bl = false;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Character c = (Character)enumeration.nextElement();
            Parameter parameter = (Parameter)hashtable.get(c);
            if (parameter.getCount() <= 0 || c.charValue() != 'x') continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static String[] parseMTMS(Parameter parameter) {
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = 0;
        String[] stringArray = null;
        string = parameter.getExtraInfo();
        if (string != null && string.length() > 0) {
            n = string.indexOf(95);
            if (n != -1) {
                if (n > 0) {
                    string2 = string.substring(0, n);
                    if (n < string.length() - 1) {
                        string3 = string.substring(n + 1);
                        stringArray = new String[]{string2, string3};
                    } else {
                        ListHSC.doExit(80 + parameter.getCount());
                    }
                } else {
                    ListHSC.doExit(80 + parameter.getCount());
                }
            } else {
                ListHSC.doExit(80 + parameter.getCount());
            }
        } else {
            ListHSC.doExit(32 + parameter.getCount());
        }
        return stringArray;
    }

    private static void listAllTypes() throws CIMException {
        boolean bl = false;
        boolean bl2 = false;
        bl = ListHSC.listType("0", false);
        bl2 = !bl;
        ListHSC.listType(BPA_TYPE_STRING, bl2);
    }

    private static boolean listType(String string, boolean bl) throws CIMException {
        Vector vector = null;
        Vector vector2 = null;
        if (string != null) {
            if (string.equals("0")) {
                vector = CIMUtils.getCECs();
                return ListHSC.writeTypeValuePairs(string, vector, bl);
            }
            if (string.equals(BPA_TYPE_STRING)) {
                vector2 = CIMUtils.getBPAs();
                return ListHSC.writeTypeValuePairs(string, vector2, bl);
            }
        }
        throw new IllegalArgumentException(string);
    }

    private static void listComponents(String string, String string2) throws CIMException {
        Vector vector = null;
        Vector vector2 = null;
        boolean bl = false;
        boolean bl2 = false;
        vector = CIMUtils.getIODrawers(string, string2);
        bl = ListHSC.writeTypeValuePairs("1", vector, false);
        bl2 = !bl;
        vector2 = CIMUtils.getBPAs(string, string2);
        ListHSC.writeTypeValuePairs(BPA_TYPE_STRING, vector2, bl2);
    }

    private static void listBPAComponents(String string, String string2) throws CIMException {
        Hashtable hashtable = null;
        Object var3_3 = null;
        Vector vector = null;
        Object var5_5 = null;
        boolean bl = false;
        boolean bl2 = false;
        String string3 = null;
        hashtable = CIMUtils.getComponentsOfBPA(string, string2);
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                string3 = (String)enumeration.nextElement();
                bl = ListHSC.writeTypeValuePairs(string3, vector = (Vector)hashtable.get(string3), false);
                if (!bl) continue;
                bl2 = true;
            }
        }
        if (!bl2) {
            if (Trace.LEVEL >= 3) {
                Trace.trace(TRACE_MASKD, "writing to standard out : ;");
            }
            System.out.print(';');
        }
    }

    private static String parseMTMS(String string) {
        String string2 = "";
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
            String string3 = stringTokenizer.nextToken();
            string2 = string3 + "-";
            string3 = stringTokenizer.nextToken();
            string2 = string2 + string3;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string2;
    }

    private static String createVpdXml(String string) {
        String string2 = null;
        String string3 = ListHSC.parseMTMS(_cecMTMS);
        Hashtable hashtable = ListHSC.extractVPDData(string);
        try {
            DocumentImpl documentImpl = new DocumentImpl();
            Element element = documentImpl.createElement("com.ibm.inventory");
            element.setAttribute("version", "1.0");
            Element element2 = documentImpl.createElement("ResourceSet");
            element2.setAttribute("class", "com.ibm.inventory.Hardware");
            element2.setAttribute("type", "Hardware");
            element2.setAttribute("version", "1.0");
            element.appendChild(element2);
            Element element3 = documentImpl.createElement("Resource");
            element3.setAttribute("displayName", string3);
            element3.setAttribute("uniqueId", string3);
            element3.appendChild(documentImpl.createTextNode(string3));
            element2.appendChild(element3);
            Element element4 = documentImpl.createElement("ResourceList");
            element4.setAttribute("displayName", "Enclosures");
            element3.appendChild(element4);
            Element element5 = documentImpl.createElement("Resource");
            String string4 = (String)hashtable.get("*DS");
            element5.setAttribute("displayName", string4);
            String string5 = (String)hashtable.get("*TM") + "-" + (String)hashtable.get("*SE");
            element5.setAttribute("uniqueId", string5);
            element5.appendChild(documentImpl.createTextNode(string4));
            element4.appendChild(element5);
            Element element6 = documentImpl.createElement("Property");
            element6.setAttribute("name", "TM");
            element6.setAttribute("displayName", "Machine type-model");
            element6.appendChild(documentImpl.createTextNode("TM"));
            Element element7 = documentImpl.createElement("Value");
            element7.setAttribute("type", "string");
            element7.appendChild(documentImpl.createTextNode((String)hashtable.get("*TM")));
            element6.appendChild(element7);
            element5.appendChild(element6);
            element6 = documentImpl.createElement("Property");
            element6.setAttribute("name", "SE");
            element6.setAttribute("displayName", "Machine Serial Number");
            element6.appendChild(documentImpl.createTextNode("SE"));
            element7 = documentImpl.createElement("Value");
            element7.setAttribute("type", "string");
            element7.appendChild(documentImpl.createTextNode((String)hashtable.get("*SE")));
            element6.appendChild(element7);
            element5.appendChild(element6);
            element6 = documentImpl.createElement("Property");
            element6.setAttribute("name", "MN");
            element6.setAttribute("displayName", "Manufacturer");
            element6.appendChild(documentImpl.createTextNode("MN"));
            element7 = documentImpl.createElement("Value");
            element7.setAttribute("type", "string");
            element7.appendChild(documentImpl.createTextNode((String)hashtable.get("*MN")));
            element6.appendChild(element7);
            element5.appendChild(element6);
            element6 = documentImpl.createElement("Property");
            element6.setAttribute("name", "PN");
            element6.setAttribute("displayName", "Part Number");
            element6.appendChild(documentImpl.createTextNode("PN"));
            element7 = documentImpl.createElement("Value");
            element7.setAttribute("type", "string");
            element7.appendChild(documentImpl.createTextNode((String)hashtable.get("*PN")));
            element6.appendChild(element7);
            element5.appendChild(element6);
            element6 = documentImpl.createElement("Property");
            element6.setAttribute("name", "SZ");
            element6.setAttribute("displayName", "Size");
            element6.appendChild(documentImpl.createTextNode("SZ"));
            element7 = documentImpl.createElement("Value");
            element7.setAttribute("type", "string");
            element7.appendChild(documentImpl.createTextNode((String)hashtable.get("*SZ")));
            element6.appendChild(element7);
            element5.appendChild(element6);
            element6 = documentImpl.createElement("Property");
            element6.setAttribute("name", "OS");
            element6.setAttribute("displayName", "Operating System");
            element6.appendChild(documentImpl.createTextNode("OS"));
            element7 = documentImpl.createElement("Value");
            element7.setAttribute("type", "string");
            element7.appendChild(documentImpl.createTextNode((String)hashtable.get("*OS")));
            element6.appendChild(element7);
            element5.appendChild(element6);
            element6 = documentImpl.createElement("Property");
            element6.setAttribute("name", "NA");
            element6.setAttribute("displayName", "Network Address");
            element6.appendChild(documentImpl.createTextNode("NA"));
            element7 = documentImpl.createElement("Value");
            element7.setAttribute("type", "string");
            element7.appendChild(documentImpl.createTextNode((String)hashtable.get("*NA")));
            element6.appendChild(element7);
            element5.appendChild(element6);
            element6 = documentImpl.createElement("Property");
            element6.setAttribute("name", "RM");
            element6.setAttribute("displayName", (String)hashtable.get("*DS2"));
            element6.appendChild(documentImpl.createTextNode("RM"));
            element7 = documentImpl.createElement("Value");
            element7.setAttribute("type", "string");
            element7.appendChild(documentImpl.createTextNode((String)hashtable.get("*RM")));
            element6.appendChild(element7);
            element5.appendChild(element6);
            documentImpl.appendChild(element);
            OutputFormat outputFormat = new OutputFormat((Document)documentImpl);
            StringWriter stringWriter = new StringWriter();
            XMLSerializer xMLSerializer = new XMLSerializer((Writer)stringWriter, outputFormat);
            xMLSerializer.asDOMSerializer();
            xMLSerializer.serialize(documentImpl.getDocumentElement());
            string2 = stringWriter.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    private static Hashtable extractVPDData(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(32);
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1, string2.length());
            if (hashtable.containsKey(string3)) {
                string3 = string3 + "2";
            }
            hashtable.put(string3, string4);
        }
        return hashtable;
    }

    private static boolean listVPD() throws CIMException {
        String string = null;
        Object var1_1 = null;
        String string2 = null;
        string = CIMUtils.getVPD();
        if (string != null && string.length() > 0) {
            if (_xmlOutput) {
                string2 = ListHSC.createVpdXml(string);
                System.out.print(string2);
            } else {
                System.out.print(string);
            }
            if (Trace.LEVEL >= 3) {
                Trace.trace(TRACE_MASKD, "writing to standard out : " + string);
            }
            return true;
        }
        return false;
    }

    private static boolean writeTypeValuePairs(String string, Vector vector, boolean bl) {
        boolean bl2 = false;
        String string2 = null;
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                System.out.print(string + ':' + string2 + ';');
                if (Trace.LEVEL >= 3) {
                    Trace.trace(TRACE_MASKD, "writing to standard out : " + string + ':' + string2 + ';');
                }
                bl2 = true;
            }
        }
        if (!bl2 && bl) {
            System.out.print(';');
            if (Trace.LEVEL >= 3) {
                Trace.trace(TRACE_MASKD, "writing to standard out : ;");
            }
            return true;
        }
        return bl2;
    }

    private static void writeValuePairs(Hashtable hashtable) {
        boolean bl = false;
        Object var2_2 = null;
        String string = null;
        String string2 = null;
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                string2 = (String)hashtable.get(string);
                System.out.print(string + ':' + string2 + ';');
                if (Trace.LEVEL >= 3) {
                    Trace.trace(TRACE_MASKD, "writing to standard out : " + string + ':' + string2 + ';');
                }
                bl = true;
            }
        }
        if (!bl) {
            System.out.print(';');
            if (Trace.LEVEL >= 3) {
                Trace.trace(TRACE_MASKD, "writing to standard out : ;");
            }
        }
    }

    private static void writeValuePairs(Vector vector) {
        Hashtable hashtable = null;
        boolean bl = false;
        Object var3_3 = null;
        String string = null;
        String string2 = null;
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                hashtable = (Hashtable)enumeration.nextElement();
                Enumeration enumeration2 = hashtable.keys();
                while (enumeration2.hasMoreElements()) {
                    string = (String)enumeration2.nextElement();
                    string2 = (String)hashtable.get(string);
                    System.out.print(string + ':' + string2 + ';');
                    if (Trace.LEVEL >= 3) {
                        Trace.trace(TRACE_MASKD, "writing to standard out : " + string + ':' + string2 + ';');
                    }
                    bl = true;
                }
            }
        }
        if (!bl) {
            System.out.print(';');
            if (Trace.LEVEL >= 3) {
                Trace.trace(TRACE_MASKD, "writing to standard out : ;");
            }
        }
    }

    private static Hashtable extractUnallocRes(Vector vector) {
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < vector.size(); ++i) {
            Vector vector2;
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            String string = (String)vector.elementAt(i);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            String string2 = null;
            while (stringTokenizer.hasMoreTokens()) {
                vector2 = stringTokenizer.nextToken();
                int n = ((String)((Object)vector2)).indexOf(32);
                String string3 = ((String)((Object)vector2)).substring(0, n);
                String string4 = ((String)((Object)vector2)).substring(n + 1, ((String)((Object)vector2)).length());
                if (hashtable2.containsKey(string3)) {
                    string3 = string3 + "2";
                }
                hashtable2.put(string3, string4);
                if (!string3.equals("*SE")) continue;
                string2 = string4;
            }
            if (string2 == null) continue;
            vector2 = (Vector)hashtable.get(string2);
            if (vector2 == null) {
                vector2 = new Vector();
            }
            vector2.addElement(hashtable2);
            hashtable.put(string2, vector2);
        }
        return hashtable;
    }

    private static Vector dummyMethod() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("*FC ????????\n*VC 20.0\n*N2 Fri Oct 10 18:40:59 CDT 2003\n");
        vector.addElement("*FC ????????\n*VB Unallocated Adapter\n*DS Ethernet controller\n*TM 7040-61D\n*SE 0000004\n*YL U7040.61D.020D59A-P2-I1\n*VI 200n\n");
        vector.addElement("*FC ????????\n*VB Unallocated Adapter\n*DS SCSI bus controller\n*TM 7040-61D\n*SE 0000004\n*YL U7040.61D.020D59A-P2-I1\n*VI 100");
        vector.addElement("*FC ????????\n*VB Unallocated Adapter\n*DS SCSI bus controller\n*TM 7040-61D\n*SE 0000004\n*YL U7040.61D.020D59A-P2-I1n*VI 100\n");
        vector.addElement("*FC ????????\n*VB Unallocated Adapter\n*DS Ethernet controller\n*TM 7040-61D\n*SE 0000004\n*YL U7040.61D.020D59A-P2-I1\n*VI 200\n");
        vector.addElement("*FC ????????\n*VB Unallocated Adapter\n*DS Ethernet controller\n*TM 7040-61D\n*SE 0000004\n*YL U7040.61D.020D59A-P2-I1\n*VI 200\n");
        vector.addElement("*FC ????????\n*VB Unallocated Adapter\n*DS SCSI bus controller\n*TM 7040-61D\n*SE 0000004\n*YL U7040.61D.020D59A-P2-I1\n*VI 100");
        vector.addElement("*FC ????????\n*VB Unallocated Adapter\n*DS ISA bridge\n*TM 7040-681\n*SE 4337315\n*YL U7040.61D.020D59A-P2-I1\n*VI 610");
        vector.addElement("*FC ????????\n*VB Unallocated Adapter\n*DS Ethernet controller\n*TM 7040-61D\n*SE 0000999\n*YL U7040.61D.020D59A-P2-I1\n*VI 200");
        vector.addElement("*FC ????????\n*VB Unallocated Adapter\n*DS SCSI bus controller\n*TM 7040-61D\n*SE 0000999\n*YL U7040.61D.020D59A-P2-I1\n*VI 100");
        vector.addElement("*FC ????????\n*VB Unallocated Adapter\n*DS Ethernet controller\n*TM 7040-61D\n*SE 0000999\n*YL U7040.61D.020D59A-P2-I1\n*VI 200");
        vector.addElement("*FC ????????\n*VB Unallocated Adapter\n*DS Ethernet controller\n*TM 7040-61D\n*SE 0000999\n*YL U7040.61D.020D59A-P2-I1\n*VI 200");
        vector.addElement("*FC ????????\n*VB Unallocated Adapter\n*DS SCSI bus controller\n*TM 7040-61D\n*SE 0000999\n*YL U7040.61D.020D59A-P2-I1\n*VI 100");
        vector.addElement("*FC ????????\n*VB Unallocated Adapter\n*DS Other Communications Device\n*TM 7040-61D\n*SE 0000999\n*YL U7040.61D.020D59A-P2-I1\n*VI 71280");
        vector.addElement("*FC ????????\n*VB Unallocated Adapter\n*DS PCI-to-PCI bridge\n*TM 7040-61D\n*SE 0000999\n*YL U7040.61D.020D59A-P2-I1\n*VI 640");
        vector.addElement("*FC ????????\n*VB Unallocated Adapter\n*DS SCSI bus controller\n*TM 7040-61D\n*SE 0000999\n*YL U7040.61D.020D59A-P2-I1\n*VI 100");
        vector.addElement("*FC ????????\n*VB Unallocated Adapter\n*DS Ethernet controller\n*TM 7040-61D\n*SE 0000999\n*YL U7040.61D.020D59A-P2-I1\n*VI 200");
        vector.addElement("*FC ????????\n*VB Unallocated Adapter\n*DS Ethernet controller\n*TM 7040-61D\n*SE 0000999\n*YL U7040.61D.020D59A-P2-I1\n*VI 200");
        vector.addElement("*FC ????????\n*VB Unallocated Adapter\n*DS Ethernet controller\n*TM 7040-61D\n*SE 0000999\n*YL U7040.61D.020D59A-P2-I1\n*VI 200");
        vector.addElement("*FC ????????\n*VB Unallocated Adapter\n*DS SCSI bus controller\n*TM 7040-61D\n*SE 0000999\n*YL U7040.61D.020D59A-P2-I1\n*VI 100");
        vector.addElement("*FC ????????\n*VB Unallocated Adapter\n*DS SCSI bus controller\n*TM 7040-61D\n*SE 0000999\n*YL U7040.61D.020D59A-P2-I1\n*VI 100");
        vector.addElement("*FC ????????\n*VB Unallocated Adapter\n*DS Ethernet controller\n*TM 7040-61D\n*SE 0000004\n*YL U7040.61D.020D59A-P2-I1\n*VI 200");
        vector.addElement("*FC ????????\n*VB Unallocated Adapter\n*DS SCSI bus controller\n*TM 7040-61D\n*SE 0000004\n*YL U7040.61D.020D59A-P2-I1\n*VI 100");
        vector.addElement("*FC ????????\n*VB Unallocated Adapter\n*DS Ethernet controller\n*TM 7040-61D\n*SE 0000004\n*YL U7040.61D.020D59A-P2-I1*VI 200");
        vector.addElement("*FC ????????\n*VB Unallocated Adapter\n*DS SCSI bus controller\n*TM 7040-61D\n*SE 0000004\n*YL U7040.61D.020D59A-P2-I1*VI 100");
        vector.addElement("*FC ????????\n*VB Unallocated Adapter\n*DS SCSI bus controller\n*TM 7040-61D\n*SE 0000004\n*YL U7040.61D.020D59A-P2-I1\n*VI 100");
        vector.addElement("*FC ????????\n*VB Unallocated Adapter\n*DS Ethernet controller\n*TM 7040-61D\n*SE 0000004\n*YL U7040.61D.020D59A-P2-I1\n*VI 200");
        return vector;
    }

    private static String createUnallocResXml(Vector vector) {
        String string = null;
        Hashtable hashtable = ListHSC.extractUnallocRes(vector);
        try {
            Hashtable hashtable2;
            Object object;
            DocumentImpl documentImpl = new DocumentImpl();
            Element element = documentImpl.createElement("com.ibm.inventory");
            element.setAttribute("version", "1.0");
            Element element2 = documentImpl.createElement("ResourceSet");
            element2.setAttribute("class", "com.ibm.inventory.Hardware");
            element2.setAttribute("type", "Hardware");
            element2.setAttribute("version", "1.0");
            element2.setAttribute("timestamp", "1234567890123");
            element.appendChild(element2);
            String string2 = null;
            OutputFormat outputFormat = hashtable.keys();
            while (outputFormat.hasMoreElements()) {
                Object object2;
                string2 = (String)outputFormat.nextElement();
                object = (Vector)hashtable.get(string2);
                hashtable2 = (Hashtable)((Vector)object).elementAt(0);
                Element element3 = documentImpl.createElement("Resource");
                String string3 = (String)hashtable2.get("*TM");
                String string4 = string2;
                String string5 = (String)hashtable2.get("*YL");
                try {
                    object2 = new StringTokenizer(string5, "-");
                    string5 = ((StringTokenizer)object2).nextToken();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                element3.setAttribute("displayName", string5);
                element3.setAttribute("uniqueId", string5);
                element3.appendChild(documentImpl.createTextNode(string5));
                element2.appendChild(element3);
                object2 = documentImpl.createElement("ResourceList");
                object2.setAttribute("displayName", "Unallocated Resources");
                element3.appendChild((Node)object2);
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    Hashtable hashtable3 = (Hashtable)((Vector)object).elementAt(i);
                    element3 = documentImpl.createElement("Resource");
                    String string6 = (String)hashtable3.get("*DS");
                    element3.setAttribute("displayName", string6);
                    String string7 = (String)hashtable3.get("*YL");
                    element3.setAttribute("uniqueId", string7);
                    element3.appendChild(documentImpl.createTextNode(string6));
                    object2.appendChild(element3);
                    Element element4 = documentImpl.createElement("Property");
                    element4.setAttribute("name", "YL");
                    element4.setAttribute("displayName", "Hardware Location Code");
                    element4.appendChild(documentImpl.createTextNode("YL"));
                    Element element5 = documentImpl.createElement("Value");
                    element5.setAttribute("type", "string");
                    element5.appendChild(documentImpl.createTextNode((String)hashtable3.get("*YL")));
                    element4.appendChild(element5);
                    element3.appendChild(element4);
                    element4 = documentImpl.createElement("Property");
                    element4.setAttribute("name", "VI");
                    element4.setAttribute("displayName", "Vendor ID");
                    element4.appendChild(documentImpl.createTextNode("VI"));
                    element5 = documentImpl.createElement("Value");
                    element5.setAttribute("type", "string");
                    element5.appendChild(documentImpl.createTextNode((String)hashtable3.get("*VI")));
                    element4.appendChild(element5);
                    element3.appendChild(element4);
                }
            }
            documentImpl.appendChild(element);
            outputFormat = new OutputFormat((Document)documentImpl);
            object = new StringWriter();
            hashtable2 = new XMLSerializer((Writer)object, outputFormat);
            hashtable2.asDOMSerializer();
            hashtable2.serialize(documentImpl.getDocumentElement());
            string = ((StringWriter)object).toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    private static void listAdapters(String string, String string2) throws PIHscClientException {
        Vector vector = null;
        String string3 = null;
        String string4 = null;
        vector = CIMUtils.getUnallocatedIODrawers(string, string2);
        if (vector != null) {
            if (_xmlOutput) {
                string4 = ListHSC.createUnallocResXml(vector);
                System.out.println(string4);
            } else {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    string3 = (String)enumeration.nextElement();
                    System.out.print(string3);
                    if (Trace.LEVEL < 3) continue;
                    Trace.trace(TRACE_MASKD, "writing to standard out : " + string3);
                }
            }
        }
    }

    private static void listHSCs(String string, String string2) throws CIMException, PIHscClientException {
        Vector vector = null;
        Object var3_3 = null;
        Object var4_4 = null;
        vector = CIMUtils.getHSCs(string, string2);
        if (vector != null) {
            ListHSC.writeValuePairs(vector);
        } else {
            System.out.print(';');
            if (Trace.LEVEL >= 3) {
                Trace.trace(TRACE_MASKD, "writing to standard out : ;");
            }
        }
    }

    private static boolean listMode(String string, String string2) throws CIMException {
        boolean bl = false;
        CIMProperty cIMProperty = null;
        CIMInstance cIMInstance = null;
        CIMValue cIMValue = null;
        UnsignedInt8 unsignedInt8 = null;
        Hashtable<String, String> hashtable = null;
        hashtable = new Hashtable<String, String>();
        hashtable.put("CreationClassName", "IBMHSC_ComputerSystem");
        hashtable.put("Name", string + '*' + string2);
        cIMInstance = CIMUtils.getInstance("IBMHSC_ComputerSystem", hashtable);
        if (cIMInstance != null && (cIMProperty = cIMInstance.getProperty("Mode")) != null && (cIMValue = cIMProperty.getValue()) != null && (unsignedInt8 = (UnsignedInt8)cIMValue.getValue()) != null) {
            switch (unsignedInt8.intValue()) {
                case 0: {
                    System.out.print("1");
                    if (Trace.LEVEL >= 3) {
                        Trace.trace(TRACE_MASKD, "writing to standard out : 1");
                    }
                    bl = true;
                    break;
                }
                case 255: {
                    System.out.print("0");
                    if (Trace.LEVEL >= 3) {
                        Trace.trace(TRACE_MASKD, "writing to standard out : 0");
                    }
                    bl = true;
                    break;
                }
            }
        }
        return bl;
    }

    private static void traceException(Exception exception) {
        StringWriter stringWriter = null;
        if (Trace.LEVEL >= 2) {
            Trace.trace(TRACE_MASKF, "Exception caught while processing the lshsc command : ");
            stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            Trace.trace(TRACE_MASKF, stringWriter.getBuffer().toString());
        }
    }

    private static void doExit(int n) {
        if (Trace.LEVEL >= 3) {
            Trace.trace(TRACE_MASKD, "lshsc returning with an exit status of " + n + ".");
        }
        System.exit(n);
    }

    private static void displayHelp() {
        System.out.println("Usage : The lshsc command accepts the following options:");
        System.out.println("        -i -tx");
        System.out.println("            Displays a list of all managed objects, of type x, known by the local");
        System.out.println("            HMC. The information is displayed as a pair of values separated by a colon");
        System.out.println("            where the first value is the type of object and the second value is specific");
        System.out.println("            to the type of object. The value pairs are in turn separated by a semicolon.");
        System.out.println("            Currently the supported value of x are 0 to display a list of CECs and 3 to");
        System.out.println("            display a list of BPAs. Also, currently the second value of the pair returned");
        System.out.println("            is the MTMS of the managed object.");
        System.out.println("        -i -a");
        System.out.println("            Displays a list of all managed objects known by the local HMC. The format");
        System.out.println("            of the information displayed is identical to that returned when the -i -tx options");
        System.out.println("            are used. Currently only information about type 0 (CEC) and type 3 (BPA)");
        System.out.println("            managed objects are displayed.");
        System.out.println("        -i -c<MTMS>");
        System.out.println("            Displays a list of all components known by the specified CEC. The format of");
        System.out.println("            the information displayed is identical to that returned when the -i -tx options");
        System.out.println("            are used. Currently, only type 1 (I/O drawer) and type 3 (BPA) components are");
        System.out.println("            displayed. Note, any internal I/O drawers, indicated with a MTMS that is");
        System.out.println("            the same as the CEC, will not be displayed.");
        System.out.println("        -i -d -c<MTMS> [-x]");
        System.out.println("            Displays information, in VPD format, about all unallocated adapters for the");
        System.out.println("            specified CEC. The information for each unallocated adapter is separated by a");
        System.out.println("            semicolon. The format of the displayed information is as follows:");
        System.out.println("               *FC ????????");
        System.out.println("               *DS Unallocated Adapter");
        System.out.println("               *TM <Model/Type of I/O Drawer>");
        System.out.println("               *SN <Serial Number of I/O Drawer>");
        System.out.println("               *YL <Location Code of Adapter>");
        System.out.println("               *VI <PCI Class Code/Vendor ID>");
        System.out.println("            Alternatively, XML output is displayed if -x is provided.");
        System.out.println("        -i -r -c<MTMS>");
        System.out.println("            Displays information about all Hardware Management Consoles controlling");
        System.out.println("            the specified CEC where the CEC is controlled by the Hardware Management Console");
        System.out.println("            running this command. The information is displayed as a pair of values separated");
        System.out.println("            by a colon where the first value is the IP address of the HMC and the second");
        System.out.println("            value is the MTMS of the HMC. The value pairs are in turn separated by a");
        System.out.println("            semicolon. The HMC running this command is returned as the first pair of values.");
        System.out.println("        -i -m -c<MTMS>");
        System.out.println("            Displays the number 0 if the specified CEC was booted in partitioned mode;");
        System.out.println("            displays the number 1 if not.");
        System.out.println("        -i -v [-x]");
        System.out.println("            Displays the Hardware Management Console's hardware VPD information in RPA VPD");
        System.out.println("            format.  Alternatively, XML output is displayed if -x is provided.");
        System.out.println("        -i -p -c<MTMS>");
        System.out.println("            Displays information about the partitions that are associated with the CEC");
        System.out.println("            specified. The information is displayed as 3 values separated by colons where");
        System.out.println("            the first value is the partition number, the second value is the IP address of");
        System.out.println("            the partition and the third value is the number 1 to indicate that the partition");
        System.out.println("            is active or the number 0 to indicate that the partition is inactive or the number");
        System.out.println("            2 to indicate that the partition is active and the partition supports inventory");
        System.out.println("            scout collection of data. The information about each partition is in turn separated");
        System.out.println("            by a semicolon. Note, if the CEC is in SMP mode, the partition number will be 0.");
        System.out.println("        -i");
        System.out.println("            Displays the number 0. This can be used to verify that the lshsc command");
        System.out.println("            is working properly.");
        System.out.println("        -w -c<MTMS>");
        System.out.println("            Displays configuration information about the partition running or booting in the");
        System.out.println("            CEC specified.");
        System.out.println("        -w -c<MTMS> -f<file>");
        System.out.println("            Writes configuration information, to the file specified, about the partition");
        System.out.println("            running or booting in the CEC specified.");
        System.out.println("        -i -b<MTMS>");
        System.out.println("            Displays a list of all components known by the specified BPA. The format of");
        System.out.println("            the information displayed is identical to that returned when the -i -tx options");
        System.out.println("            are used. Currently, only type 0 (CEC) and type 1 (I/O drawer) components");
        System.out.println("            (including internal I/O drawers).");
        System.out.println("        -x  Output in XML format.  Only valid for -v and -d flags.");
        System.out.println("");
        System.out.println("");
        System.out.println("");
        System.out.println("Notes : The format of the MTMS option is the machine type and model followed by an underscore");
        System.out.println("        character followed by the serial number (e.g. 7043-150_1234567).");
        System.out.println("");
        System.out.println("        The options may be specified in any order.");
        System.out.println("");
        System.out.println("        A return code other than 0 indicates an error.");
        System.out.println("");
        System.out.println("");
    }

    private static class Parameter {
        private boolean extraInfoRequired = false;
        private int argCount = 0;
        private String extraInfo = null;

        private Parameter(boolean bl, int n) {
            this.extraInfoRequired = bl;
            this.argCount = n;
            this.extraInfo = null;
        }

        private int getCount() {
            return this.argCount;
        }

        private void setCount(int n) {
            this.argCount = n;
        }

        private boolean getExtraInfoRequired() {
            return this.extraInfoRequired;
        }

        private void setExtraInfoRequired(boolean bl) {
            this.extraInfoRequired = bl;
        }

        private String getExtraInfo() {
            return this.extraInfo;
        }

        private void setExtraInfo(String string) {
            this.extraInfo = string;
        }
    }
}

